/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.planning.algorithms;

import cz.insophy.inplan.plan.OfflineActivity;
import cz.insophy.inplan.shop.Material;
import cz.insophy.inplan.store.StoreSchedule;
import cz.insophy.inplan.util.AbstractComparableIterator;
import cz.insophy.inplan.util.Comparators;
import cz.insophy.inplan.util.Tuple;
import java.util.Iterator;

public class MatOfflineIterator
extends AbstractComparableIterator<OfflineActivity> {
    private final double threshold;
    private final Iterator<Tuple<Long, Double>> it;

    public MatOfflineIterator(StoreSchedule storeSch, Material mat, long start, double threshold) {
        this.threshold = threshold;
        this.it = storeSch.quantityIterator(mat, true, start);
        this.prepareNext();
    }

    @Override
    protected void prepareNext() {
        long blockStart = Long.MAX_VALUE;
        while (this.it.hasNext()) {
            Tuple<Long, Double> qtyInfo = this.it.next();
            long time = qtyInfo.getFirst();
            double qty = qtyInfo.getSecond();
            if (Comparators.compare(qty, this.threshold, 1.0E-7) < 0 && blockStart == Long.MAX_VALUE) {
                blockStart = time;
                continue;
            }
            if (Comparators.compare(qty, this.threshold, 1.0E-7) < 0 || blockStart == Long.MAX_VALUE) continue;
            this.setNext(new OfflineActivity(blockStart, time, null, true));
            return;
        }
        if (blockStart != Long.MAX_VALUE) {
            this.setNext(new OfflineActivity(blockStart, Long.MAX_VALUE, null, true));
        } else {
            this.setNext(null);
        }
    }
}

